﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Security;
using System.Runtime.InteropServices;

namespace BMS.Utils
{
    public static class SecureStringUtils
    {
        //  Usage:
        //string password = "SecretPassword";
        //SecureString securePassword = password.ConvertToSecureString();
        //string password2 = securePassword.ConvertToUnsecureString();

        public static string ConvertToUnsecureString(this SecureString secureStr)
        {
            if (secureStr == null)
                return null;

            IntPtr unmanagedString = IntPtr.Zero;

            try
            {
                unmanagedString = Marshal.SecureStringToGlobalAllocUnicode(secureStr);
                char[] newString = new char[secureStr.Length];
                for (Int32 i = 0; i < secureStr.Length; i++)
                {
                    newString[i] = (Char)Marshal.ReadInt16(unmanagedString, i * 2);
                }
 
                return new string(newString);
            }
            finally
            {
                Marshal.ZeroFreeGlobalAllocUnicode(unmanagedString);
            }
        }

        public static SecureString ConvertToSecureString(this string unsecureStr)
        {
            if (unsecureStr == null)
                return null;

            SecureString secureStr = new SecureString();
            for (int i = 0; i < unsecureStr.Length; i++)
            {
                secureStr.AppendChar(unsecureStr[i]);
            }
            secureStr.MakeReadOnly();
            return secureStr;
        }
    }
}
